////////////////////////////
// Program : Infix2Profix //
// By : Hamidreza Moeini  //
////////////////////////////

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <iostream.h>

#define MAX_STACK_SIZE 100
#define MAX_EXPR_SIZE 100
typedef enum{lparen,rparen,plus,minus,times,divide,mod,eos,operand}precedence;
int stack[MAX_STACK_SIZE];
precedence postfix_stack[MAX_STACK_SIZE];
int isp[] = {0,19,12,12,13,13,13,0};
int icp[] = {20,19,12,12,13,13,13,0};
char post_expr[MAX_EXPR_SIZE];
char infix_expr[MAX_EXPR_SIZE];
char beep[]={7,0};

precedence get_token_post(char *,int *);	// Check postfix token
precedence get_token_infix(char *,int *);	// Check infix token
int stack_delete(int *);		// Delete from stack
void stack_add(int *,int);		// Insert into stack
precedence postfix_stack_delete(int *);	// Delete from postfix stack
void stack_add(int *,precedence);	// Insert into portfix stack
int eval();				// Evaluate postfix expression value
void postfix();				// Convert infix 2 postfix
void make_postfix_string(char);		// Insert a character into postfix expression
char token2str(precedence);		// Return char value of a precedence
void main()
{
	clrscr();
	cout << "Enter Expression :\n\n";
	scanf("%s",&infix_expr);
	postfix();
	cout << "\n\nPostfix expression:\n" << post_expr << "\n\n";
	cout << infix_expr << " = " << eval() << beep << beep << beep;
	getch();
}

precedence get_token_post(char *symbol,int *n)
{
	*symbol = post_expr[(*n)++];
	switch(*symbol)
	{
		case '(' : return lparen;
		case ')' : return rparen;
		case '+' : return plus;
		case '-' : return minus;
		case '/' : return divide;
		case '*' : return times;
		case '%' : return mod;
		case '\0' : return eos;
		default : return operand;
	}
}

precedence get_token_infix(char *symbol,int *n)
{
	*symbol = infix_expr[(*n)++];
	switch(*symbol)
	{
		case '(' : return lparen;
		case ')' : return rparen;
		case '+' : return plus;
		case '-' : return minus;
		case '/' : return divide;
		case '*' : return times;
		case '%' : return mod;
		case '\0' : return eos;
		default : return operand;
	}
}

int eval()
{
	precedence token;
	int temp;
	char symbol;
	int op1,op2,n=0,top=-1;
	token = get_token_post(&symbol, &n);
	while(token != eos)
	{
		if(token == operand)
		{
			cout << "Enter Value For  "<< post_expr[n-1] << ":" << beep;
			cin >> temp;
//			stack_add(&top,symbol-'0');
			stack_add(&top,temp);
		}
		else
		{
			op2 = stack_delete(&top);
			op1 = stack_delete(&top);
			switch(token)
			{
				case plus: stack_add(&top, op1+op2);
					break;
				case minus: stack_add(&top, op1-op2);
					break;
				case times: stack_add(&top, op1*op2);
					break;
				case divide: stack_add(&top, op1/op2);
					break;
				case mod: stack_add(&top, op1%op2);
			}
		 }
		 token = get_token_post(&symbol, &n);
	}
	cout << "\n";
	return stack_delete(&top);
}

void stack_add(int *top,int item)
{
	if(*top >= MAX_STACK_SIZE-1)
	{
		cout << "Stack overflow" << beep;
		getch();
		exit(0);
	}
	stack[++*top] = item;
}

int stack_delete(int *top)
{
	if(*top == -1)
	{
		cout << "Stack is empty" << beep;
		getch();
		exit(0);
	}
	return stack[(*top)--];
}

void postfix_stack_add(int *top,precedence item)
{
	if(*top >= MAX_STACK_SIZE-1)
	{
		cout << "Stack overflow" << beep;
		getch();
		exit(0);
	}
	postfix_stack[++*top] = item;
}

precedence postfix_stack_delete(int *top)
{
	if(*top == -1)
	{
		cout << "Stack is empty" << beep;
		getch();
		exit(0);
	}
	return postfix_stack[(*top)--];
}

void postfix()
{
	char symbol;
	precedence token;
	int n=0,top=0;
	postfix_stack[0] = eos;
	for(int i=0;i<MAX_EXPR_SIZE;i++)
		post_expr[i]=0;
	for(token = get_token_infix(&symbol, &n);token != eos; token = get_token_infix(&symbol, &n))
	{
		if(token == operand)
		{
			make_postfix_string(symbol);
		}
		else if(token == rparen)
		{
			while(stack[top] != lparen)
				make_postfix_string(token2str(postfix_stack_delete(&top)));
			postfix_stack_delete(&top);
		}
		else
		{
			while(isp[stack[top]] >= icp[token])
				make_postfix_string(token2str(postfix_stack_delete(&top)));
			postfix_stack_add(&top, token);
		}
	}
	while((token=postfix_stack_delete(&top)) != eos)
		make_postfix_string(token2str(token));
	make_postfix_string('\0');
}

void make_postfix_string(char s)
{
	int i=0;
	while(post_expr[i])
		i++;
	post_expr[i]=s;
}

char token2str(precedence token)
{
	switch(token)
	{
		case lparen : return '(';
		case rparen : return ')';
		case plus : return '+';
		case minus : return '-';
		case divide : return '/';
		case times : return '*';
		case mod : return '%';
		default:
			cout << "Invalid Token" << beep;
			getch();
	}
	return('\0');
}