// Sudoku problem solver
// programmer : mostafa vatanpoor 
// email : mostafa_vtp@yahoo.com
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace sudoku
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		DataGridCell[] history=new DataGridCell[81];
		int position=-1;
		bool findFirst;
		Thread calcThread;
		//DataGrid dataGrid2=new DataGrid();
		//-----------------------------------------------------------------------
		private System.Windows.Forms.DataGrid dataGrid1;
		private System.Windows.Forms.Button btnLoad;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Button BtnReset;
		private System.Windows.Forms.Button btnStop;
		private System.Windows.Forms.CheckBox chkFastScan;
		private System.Windows.Forms.Button btnFind;
		private System.Windows.Forms.Button btnNext;
		private System.Windows.Forms.Button btnSave;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.Panel panel4;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.Panel panel3;
		private System.ComponentModel.IContainer components;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnNext = new System.Windows.Forms.Button();
			this.dataGrid1 = new System.Windows.Forms.DataGrid();
			this.btnFind = new System.Windows.Forms.Button();
			this.btnSave = new System.Windows.Forms.Button();
			this.btnLoad = new System.Windows.Forms.Button();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.BtnReset = new System.Windows.Forms.Button();
			this.btnStop = new System.Windows.Forms.Button();
			this.chkFastScan = new System.Windows.Forms.CheckBox();
			this.btnClear = new System.Windows.Forms.Button();
			this.panel4 = new System.Windows.Forms.Panel();
			this.panel1 = new System.Windows.Forms.Panel();
			this.panel2 = new System.Windows.Forms.Panel();
			this.panel3 = new System.Windows.Forms.Panel();
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).BeginInit();
			this.SuspendLayout();
			// 
			// btnNext
			// 
			this.btnNext.Location = new System.Drawing.Point(104, 16);
			this.btnNext.Name = "btnNext";
			this.btnNext.TabIndex = 1;
			this.btnNext.Text = "Next";
			this.btnNext.Click += new System.EventHandler(this.btnNext_Click);
			// 
			// dataGrid1
			// 
			this.dataGrid1.BackgroundColor = System.Drawing.Color.DarkGray;
			this.dataGrid1.CaptionVisible = false;
			this.dataGrid1.DataMember = "";
			this.dataGrid1.Font = new System.Drawing.Font("Tahoma", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(178)));
			this.dataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGrid1.Location = new System.Drawing.Point(56, 104);
			this.dataGrid1.Name = "dataGrid1";
			this.dataGrid1.PreferredColumnWidth = 24;
			this.dataGrid1.PreferredRowHeight = 24;
			this.dataGrid1.Size = new System.Drawing.Size(264, 248);
			this.dataGrid1.TabIndex = 2;
			// 
			// btnFind
			// 
			this.btnFind.Location = new System.Drawing.Point(16, 16);
			this.btnFind.Name = "btnFind";
			this.btnFind.TabIndex = 3;
			this.btnFind.Text = "Find First";
			this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
			// 
			// btnSave
			// 
			this.btnSave.Location = new System.Drawing.Point(40, 384);
			this.btnSave.Name = "btnSave";
			this.btnSave.TabIndex = 4;
			this.btnSave.Text = "Save";
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// btnLoad
			// 
			this.btnLoad.Location = new System.Drawing.Point(256, 384);
			this.btnLoad.Name = "btnLoad";
			this.btnLoad.TabIndex = 5;
			this.btnLoad.Text = "Load";
			this.btnLoad.Click += new System.EventHandler(this.btnLoad_Click);
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(136, 384);
			this.textBox1.Name = "textBox1";
			this.textBox1.TabIndex = 6;
			this.textBox1.Text = "temp.xml";
			// 
			// BtnReset
			// 
			this.BtnReset.Location = new System.Drawing.Point(192, 16);
			this.BtnReset.Name = "BtnReset";
			this.BtnReset.TabIndex = 7;
			this.BtnReset.Text = "Reset";
			this.BtnReset.Click += new System.EventHandler(this.BtnReset_Click);
			// 
			// btnStop
			// 
			this.btnStop.Location = new System.Drawing.Point(176, 56);
			this.btnStop.Name = "btnStop";
			this.btnStop.TabIndex = 8;
			this.btnStop.Text = "Stop";
			this.btnStop.Click += new System.EventHandler(this.btnStop_Click);
			// 
			// chkFastScan
			// 
			this.chkFastScan.Location = new System.Drawing.Point(48, 56);
			this.chkFastScan.Name = "chkFastScan";
			this.chkFastScan.Size = new System.Drawing.Size(88, 24);
			this.chkFastScan.TabIndex = 9;
			this.chkFastScan.Text = "Fast Search";
			this.chkFastScan.CheckedChanged += new System.EventHandler(this.chkFastScan_CheckedChanged);
			// 
			// btnClear
			// 
			this.btnClear.Location = new System.Drawing.Point(280, 16);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 10;
			this.btnClear.Text = "Clear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// panel4
			// 
			this.panel4.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel4.Location = new System.Drawing.Point(56, 271);
			this.panel4.Name = "panel4";
			this.panel4.Size = new System.Drawing.Size(264, 1);
			this.panel4.TabIndex = 11;
			// 
			// panel1
			// 
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel1.Location = new System.Drawing.Point(56, 199);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(264, 1);
			this.panel1.TabIndex = 11;
			// 
			// panel2
			// 
			this.panel2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel2.Location = new System.Drawing.Point(164, 104);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(1, 248);
			this.panel2.TabIndex = 11;
			// 
			// panel3
			// 
			this.panel3.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel3.Location = new System.Drawing.Point(236, 104);
			this.panel3.Name = "panel3";
			this.panel3.Size = new System.Drawing.Size(1, 248);
			this.panel3.TabIndex = 11;
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
			this.ClientSize = new System.Drawing.Size(376, 437);
			this.Controls.Add(this.panel3);
			this.Controls.Add(this.panel2);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.panel4);
			this.Controls.Add(this.btnClear);
			this.Controls.Add(this.chkFastScan);
			this.Controls.Add(this.btnStop);
			this.Controls.Add(this.BtnReset);
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.btnLoad);
			this.Controls.Add(this.btnSave);
			this.Controls.Add(this.btnFind);
			this.Controls.Add(this.dataGrid1);
			this.Controls.Add(this.btnNext);
			this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(178)));
			this.Name = "Form1";
			this.Text = "Sudoku";
			this.Load += new System.EventHandler(this.Form1_Load);
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		void find()
		{
			if(findFirst || position==-1)
			{
				for(int i=0;i<=position;i++)
				{
					dataGrid1[history[i]]="";
				}
				bool found=false;
				for(int i=0;i<9;i++)
				{
					for(int j=0;j<9;j++)
					{
						if((string)dataGrid1[i,j]=="")
						{
							history[0]=new DataGridCell(i,j);
							dataGrid1[history[0]]="0";
							position=0;
							found=true;
							break;
						}
					}
					if(found) break;
				}
			}
			while(position>=0)
			{
				while(strToInt(dataGrid1[history[position]])<9)
				{
					dataGrid1[history[position]]=strToInt(dataGrid1[history[position]])+1;
					if(checkCell(history[position]))
					{
						bool found=false;
						for(int i=0;i<9;i++)
						{
							for(int j=0;j<9;j++)
							{
								if((string)dataGrid1[i,j]=="")
								{
									position++;
									history[position]=new DataGridCell(i,j);
									dataGrid1[history[position]]="0";
									found=true;
									break;
								}
							}
							if(found) break;
						}
						if(!found)
						{
							enableButtons();
							return;
						}
					}
				}
				dataGrid1[history[position]]="";
				position--;
			}
			enableButtons();
		}

		bool checkCell(DataGridCell cell)
		{
			//check horizontal
			for(int i=0;i<9;i++)
			{
				if(i!=cell.ColumnNumber && (string)dataGrid1[cell.RowNumber,i]==(string)dataGrid1[cell])
				{
					return false;
				}
			}
			//check vertical
			for(int i=0;i<9;i++)
			{
				if(i!=cell.RowNumber && (string)dataGrid1[i,cell.ColumnNumber]==(string)dataGrid1[cell])
				{
					return false;
				}
			}
			//check small square
			for(int i=(int)(Math.Floor(cell.RowNumber/3)*3);i<Math.Floor(cell.RowNumber/3)*3+3;i++)
			{
				for(int j=(int)(Math.Floor(cell.ColumnNumber/3)*3);j<Math.Floor(cell.ColumnNumber/3)*3+3;j++)
				{
					if(!(i==cell.RowNumber && j==cell.ColumnNumber) && (string)dataGrid1[i,j]==(string)dataGrid1[cell])
					{
						return false;
					}
				}
			}
			return true;
		}

		int strToInt(object o1)
		{
			if(o1 as string == null)return 0;
			string str=(string)o1;
			try
			{
				return int.Parse(str);
			}
			catch
			{
				return 0;
			}
		}

		void enableButtons()
		{
			btnFind.Enabled=true;
			btnNext.Enabled=true;
			btnClear.Enabled=true;
			BtnReset.Enabled=true;
		}
		void disableButtons()
		{
			btnFind.Enabled=false;
			btnNext.Enabled=false;
			btnClear.Enabled=false;
			BtnReset.Enabled=false;
		}
		//**********************                                       *******************
		//**********************                                       *******************
		//**********************                                       *******************
		//**********************                                       *******************
		//**********************                                       *******************
		//**********************                                       *******************

		private void Form1_Load(object sender, System.EventArgs e)
		{
			DataTable t1=new DataTable();
			for(int i=1;i<=9;i++)
			{
				t1.Columns.Add("c"+i,typeof(string));
			}
			for(int i=1;i<=9;i++)
			{
				DataRow r1=t1.NewRow();
				for(int j=1;j<=9;j++)
				{
					r1[j-1]="";
				}
				t1.Rows.Add(r1);
			}
			t1.DefaultView.AllowNew=false;
			t1.DefaultView.AllowDelete=false;
			dataGrid1.DataSource=t1;
		}

		private void btnFind_Click(object sender, System.EventArgs e)
		{
			disableButtons();
			findFirst=true;
			if(calcThread==null || !calcThread.IsAlive)
			{
				calcThread=new Thread(new ThreadStart(find));
				if(chkFastScan.Checked)
				{
					calcThread.Priority=ThreadPriority.AboveNormal;
				}
				calcThread.Start();
			}
		}

		private void btnNext_Click(object sender, System.EventArgs e)
		{
			disableButtons();
			findFirst=false;
			if(calcThread==null || !calcThread.IsAlive)
			{
				calcThread=new Thread(new ThreadStart(find));
				if(chkFastScan.Checked)
				{
					calcThread.Priority=ThreadPriority.AboveNormal;
				}
				calcThread.Start();
			}
		}

		private void btnSave_Click(object sender, System.EventArgs e)
		{
			DataSet ds1=new DataSet();
			ds1.Tables.Add((DataTable)dataGrid1.DataSource);
			ds1.WriteXml(textBox1.Text,XmlWriteMode.WriteSchema);
		}

		private void btnLoad_Click(object sender, System.EventArgs e)
		{
			DataSet ds1=new DataSet();
			ds1.ReadXml(textBox1.Text);
			DataTable t1=ds1.Tables[0];
			t1.DefaultView.AllowNew=false;
			t1.DefaultView.AllowDelete=false;
			dataGrid1.DataSource=t1;
		}

		private void BtnReset_Click(object sender, System.EventArgs e)
		{
			for(int i=0;i<=position;i++)
			{
				dataGrid1[history[i]]="";
			}
			position=-1;
		}

		private void btnStop_Click(object sender, System.EventArgs e)
		{
			enableButtons();
			calcThread.Abort();
		}

		private void chkFastScan_CheckedChanged(object sender, System.EventArgs e)
		{
			if(chkFastScan.Checked && calcThread!=null && calcThread.IsAlive)
			{
				calcThread.Priority=ThreadPriority.AboveNormal;
			}
		}

		private void btnClear_Click(object sender, System.EventArgs e)
		{
			Form1_Load(sender,e);
			position=-1;
		}
	}
}
