/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class Graphicizer
extends JFrame
implements ActionListener,
MouseListener {
    GImage bufferedImage = null;
    GImage bufferedImageBackup;
    Image image;
    Menu menu;
    MenuBar menubar;
    MenuItem menuItem1;
    MenuItem menuItem2;
    MenuItem menuItem3;
    MenuItem menuItem4;
    MenuItem menuItem5;
    MenuItem menuItem6;
    MenuItem menuItem7;
    MenuItem menuItem8;
    Button button1;
    Button button2;
    Button button3;
    Button button4;
    Button button5;
    FileDialog dialog;
    JPanel imagePanel;
    JSeparator jSeparator;
    String extension;

    public static void main(String[] args) {
        new Graphicizer();
    }

    public Graphicizer() throws HeadlessException {
        this.setSize(800, 600);
        this.setLocation(20, 20);
        this.setTitle("Steganography");
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.menubar = new MenuBar();
        this.menu = new Menu("File");
        this.menuItem1 = new MenuItem("Open...");
        this.menu.add(this.menuItem1);
        this.menuItem1.addActionListener(this);
        this.menuItem2 = new MenuItem("Save As...");
        this.menu.add(this.menuItem2);
        this.menuItem2.addActionListener(this);
        this.menuItem3 = new MenuItem("Open Text & Migrate");
        this.menu.add(this.menuItem3);
        this.menuItem3.addActionListener(this);
        this.menuItem4 = new MenuItem("Splite Text From Image");
        this.menu.add(this.menuItem4);
        this.menuItem4.addActionListener(this);
        this.menuItem7 = new MenuItem("Open Image & Migrate");
        this.menu.add(this.menuItem7);
        this.menuItem7.addActionListener(this);
        this.menuItem8 = new MenuItem("Splite Image From Image");
        this.menu.add(this.menuItem8);
        this.menuItem8.addActionListener(this);
        this.menuItem5 = new MenuItem("Exit");
        this.menu.add(this.menuItem5);
        this.menuItem5.addActionListener(this);
        this.addMouseListener(this);
        this.menubar.add(this.menu);
        this.setMenuBar(this.menubar);
        this.dialog = new FileDialog((Frame)this, "File Dialog");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ImageInOut imageInOut;
        if (e.getSource() == this.menuItem1) {
            try {
                imageInOut = new ImageInOut();
                this.bufferedImage = imageInOut.openImage();
                this.extension = imageInOut.extension;
                this.setSize(this.getInsets().left + this.getInsets().right + Math.max(400, this.bufferedImage.getBufferedImage().getWidth() + 60), this.getInsets().top + this.getInsets().bottom + Math.max(340, this.bufferedImage.getBufferedImage().getHeight() + 60));
                this.imagePanel.setSize(this.getWidth() - 100, this.getHeight() - 300);
                this.jSeparator.setSize(this.getWidth(), 2);
                this.jSeparator.setLocation(0, this.imagePanel.getHeight() + 50);
                this.button1.setBounds(30, this.getHeight() - 30, 60, 20);
                this.button2.setBounds(100, this.getHeight() - 30, 60, 20);
                this.button3.setBounds(170, this.getHeight() - 30, 60, 20);
                this.button4.setBounds(240, this.getHeight() - 30, 60, 20);
                this.button5.setBounds(310, this.getHeight() - 30, 60, 20);
            }
            catch (Exception e3) {
                System.out.println("e3 = " + e3);
            }
            this.repaint();
        }
        if (e.getSource() == this.menuItem2) {
            this.saveImage(this.bufferedImage, this.extension);
        }
        if (e.getSource() == this.menuItem3) {
            int lenght;
            File input = this.openText();
            String[] str = ToBinary.toBinary(input);
            int hajm = this.bufferedImage.getBufferedImage().getWidth() * this.bufferedImage.getBufferedImage().getHeight();
            if (hajm < (lenght = str.length)) {
                JOptionPane.showMessageDialog(null, "The Image is too small");
                return;
            }
            Steganography s = new Steganography();
            this.bufferedImage.bufferedImage = s.migrateTextImage(this.bufferedImage, str);
            this.repaint();
        }
        if (e.getSource() == this.menuItem4) {
            this.saveText();
            this.repaint();
        }
        if (e.getSource() == this.menuItem5) {
            this.setVisible(false);
        }
        if (e.getSource() == this.menuItem7) {
            imageInOut = new ImageInOut();
            GImage migrationImage = imageInOut.openImage();
            int lenght = migrationImage.getBufferedImage().getHeight() * migrationImage.getBufferedImage().getWidth();
            int lenghDes = this.bufferedImage.getBufferedImage().getHeight() * this.bufferedImage.getBufferedImage().getWidth();
            if ((lenghDes = lenghDes / 3 - 10 * this.bufferedImage.getBufferedImage().getHeight()) <= lenght) {
                JOptionPane.showMessageDialog(null, "This Pic Is Too Large", "Erroe", -1);
                return;
            }
            String extension = imageInOut.getExtension();
            extension = extension.substring(extension.indexOf(".") + 1);
            Steganography steganography = new Steganography();
            String password = JOptionPane.showInputDialog("Please Insert Password (6 character)");
            String passwordConfirm = JOptionPane.showInputDialog("Please ReInsert Password");
            while (password.compareTo(passwordConfirm) != 0 || password.length() > 6 || password.length() < 6) {
                password = JOptionPane.showInputDialog("Please Insert Password (6 character)");
                passwordConfirm = JOptionPane.showInputDialog("Please ReInsert Password");
            }
            this.bufferedImage = steganography.migrateImageImage(this.bufferedImage, migrationImage, extension, password);
        }
        if (e.getSource() == this.menuItem8) {
            Steganography s = new Steganography();
            String password = JOptionPane.showInputDialog("Please Inseert Password");
            GImage split = s.SpliteImageImage(this.bufferedImage, password);
            if (split == null) {
                return;
            }
            this.saveImage(split, s.extension);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.bufferedImage != null) {
            g.drawImage(this.bufferedImage.getBufferedImage(), this.getSize().width / 2 - this.bufferedImage.getBufferedImage().getWidth() / 2, this.getInsets().top + 20, this);
        } else {
            super.paint(g);
        }
    }

    private void saveImage(GImage image, String extension) {
        this.dialog.setMode(1);
        this.dialog.setTitle("BMP File Name For Saving");
        this.dialog.setFile("*." + extension);
        this.dialog.setVisible(true);
        try {
            if (!this.dialog.getFile().equals("")) {
                String outfile = this.dialog.getFile();
                File outputFile = new File(this.dialog.getDirectory() + outfile);
                ImageIO.write((RenderedImage)image.getBufferedImage(), outfile.substring(outfile.length() - 3, outfile.length()), outputFile);
                System.out.println(image.getBufferedImage().getType());
            }
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
        }
        this.repaint();
    }

    private File openText() {
        this.dialog.setMode(0);
        this.dialog.setTitle("TXT File Name For Opening");
        this.dialog.setVisible(true);
        File input = null;
        try {
            if (!this.dialog.getFile().equals("")) {
                input = new File(this.dialog.getDirectory() + this.dialog.getFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return input;
    }

    public void saveText() {
        Steganography s = new Steganography();
        s.spliteTextImage(this.bufferedImage);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public class ImageInOut {
        GImage bufferImage = null;
        public String extension = "BMP";

        public GImage openImage() {
            Graphicizer.this.dialog.setMode(0);
            Graphicizer.this.dialog.setTitle("BMP File Name For Opening");
            Graphicizer.this.dialog.setVisible(true);
            try {
                if (!Graphicizer.this.dialog.getFile().equals("")) {
                    File input = new File(Graphicizer.this.dialog.getDirectory() + Graphicizer.this.dialog.getFile());
                    this.bufferImage = new GImage(ImageIO.read(input));
                    this.extension = input.getName();
                    System.out.println(this.bufferImage.getBufferedImage().getType());
                    int t = this.bufferImage.getBufferedImage().getRGB(50, 10);
                    int red = GImage.getRed(t);
                    int green = GImage.getGreen(t);
                    int blue = GImage.getBlue(t);
                    System.out.println("red = " + red);
                    System.out.println("red = " + green);
                    System.out.println("red = " + blue);
                    Graphicizer.this.bufferedImageBackup = this.bufferImage;
                }
            }
            catch (Exception e1) {
                System.out.println(e1.getMessage());
            }
            return this.bufferImage;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

