#define  NULL       0L            /*NULL pointer in compact and large*/
#define  STR_LIMIT 120            /*Larger than any max string str_max*/
#define  OFFSET     20            /*Offset for shifted display*/
#define  ROW_MAX    22            /*Maximum row to be displayed in window*/
#define  COL_MAX    77            /*Maximum col to be displayed in window*/
#define  PAGE_SIZE  16            /*Number of lines during page up/down*/
#define  LINK_MAX   32            /*For Prolog*/
#define  LINK_SIZE  40            /*For Prolog*/
#define  HALF (ROW_MAX/2)         /*Row for middle line in split screen*/
#define  EDIT_COL_START  2        /*Edit window location in absolute*/
#define  EDIT_COL_END    79       /*  screen row and column*/
#define  EDIT_ROW_START  2
#define  EDIT_ROW_END    24
#define  fore_color LIGHTGREEN    /*Foreground color - edit window*/
#define  back_color BLUE          /*Background color - edit window*/
#define  fore_help  BLACK         /*Foreground color for help lines*/
#define  back_help  LIGHTGRAY     /*Background color for help lines*/

#define  ed_for         257       /*Cursor forward character*/
#define  ed_back        258       /*Cursor back character*/
#define  ed_up          259       /*Cursor up row*/
#define  ed_down        260       /*Cursor down row*/
#define  ed_word_for    261       /*Cursor word forward*/
#define  ed_word_back   262       /*Cursor word back*/
#define  ed_home        263       /*Cursor to beginning of line*/
#define  ed_end         264       /*Cursor to end of line*/
#define  ed_pgup        265       /*Cursor page up*/
#define  ed_pgdn        266       /*Cursor page down*/
#define  ed_scrn_up     267       /*Cursor to beginning of screen*/
#define  ed_scrn_down   268       /*Cursor to end of screen*/
#define  ed_top         269       /*Cursor to beginning of text*/
#define  ed_bottom      270       /*Cursor to end of text*/
#define  ed_del_for     271       /*Delete character forward*/
#define  ed_del_back    272       /*Delete character back*/
#define  ed_del_w_for   273       /*Delete word forward*/
#define  ed_del_w_back  274       /*Delete word back*/
#define  ed_del_l_for   275       /*Delete line forward*/
#define  ed_del_l_back  276       /*Delete line back*/
#define  ed_del_line    277       /*Delete entire line*/
#define  ed_new_line    278       /*Insert new line*/
#define  ed_rtl         280       /*Right to left language*/
#define  ed_ltr         281       /*Left to right within rtl*/
#define  ed_mark        290       /*Begin block marking*/
#define  ed_copy        291       /*Copy block to paste buffer*/
#define  ed_cut         292       /*Cut block to paste buffer*/
#define  ed_paste       293       /*Paste contents of buffer*/
#define  ed_goto_line   294       /*Go to line by number*/
#define  ed_undelete    295       /*Insert previous deletion*/
#define  ed_search      300       /*Search for a string*/
#define  ed_again       301       /*Search again same string*/
#define  ed_replace     302       /*Replace string*/
#define  ed_insert      310       /*Insert text from external file*/
#define  ed_help        311       /*Display help screen*/
#define  ed_new_file    312       /*Edit new file*/
#define  ed_exit        320       /*Exit editor, save file*/
#define  ed_quit        321       /*Quit editor, do not save*/
#define  ed_save        322       /*Save file and continue*/
#define  ed_format      323       /*Format file*/
#define  ed_view        324       /*View file*/
#define  ed_print       325       /*Print file*/
#define  ed_esc         330       /*Escape key to cancel operation*/
#define  ed_shift_left  340       /*Shift screen left*/
#define  ed_shift_right 341       /*Shift screen right*/
#define  ed_split       342       /*Split screen and back to full screen*/
#define  ed_join_cursor 343       /*Join cursors*/
#define  ed_window      349       /*Other window*/
#define  ed_reverse     350
#define  ed_undefined   360       /*Undefined key*/
#define  ed_latex_1     361
#define  ed_latex_2     362
#define  ed_latex_3     363
#define  ed_latex_4     364
#define  ed_latex_5     365
#define  ed_latex_6     366
#define  ed_latex_7     367
#define  ed_latex_8     368
#define  ed_latex_9     369
#define  ed_latex_10    370
#define  ed_latex_11    371
#define  ed_latex_12    372
#define  ed_latex_13    373
#define  ed_latex_14    374
#define  ed_latex_15    375
#define  ed_latex_16    376
#define  ed_latex_17    377
#define  ed_latex_18    378
#define  ed_latex_19    379
#define  ed_latex_20    380

typedef enum  {FALSE, TRUE} boolean;
typedef enum  {file_p, search_p,  replace_p_1, replace_p_2,
	       line_p, confirm_p, quit_p} prompts;
typedef enum  {yes_a, no_a, rest_a, quit_a} answers;
typedef enum  {up, down, back, forwrd} direction;
typedef enum  {ch, wrd,  lin,  scrn, pg, txt} token;
typedef struct {
       short int len;          /*Current length of string*/
       char  s[120];
     }  str_rec;
typedef str_rec *str_ptr;      /*Pointer to a string record*/

  void mouse_get(int *, int *, int *);
  void mouse_init(void);
  void mouse_off(void);
  void mouse_on(void);
  void mouse_released(int *, int *);
  void bell(void);
  void change_language(void);
  void clear_line(void);
  void clear_screen(int, int);
  boolean  compare_answer(answers, str_rec);
  boolean  confirm(void);
  void create_edit_window(void);
  void display_help(void);
  void erase(int);
  void get_answer(int *);
  void get_integer(prompts, int *);
  void get_string(prompts,  str_rec *);
  void init_display1(void);
  boolean ltr(void);
  boolean rtl(void);
  void set_rtl(boolean);
  void scroll_up(void);
  void scroll_down(void);
  void set_colors(int, int);
  void toggle_ltr(void);
  void write_frame(int, int, int, int);
  void write_help_lines();
  void get_key(int *, boolean *, boolean);
  void wait_key(int *);
  void format_file(void);
  void move_cursor(token, direction);
  void cursor_to_line_number(int);
  void mouse_sync(int, int, int *);
  void insert_char(unsigned char, int);
  void delete(token, direction);
  void new_line(void);
  void search_string(char *,  int, int, boolean *);
  void replace_string(char *, int, char *, int);
  char to_upper(char);
  void cancel_command(void);
  void mark_block(void);
  void cut_copy_block(int, unsigned long int);
  void paste_block(unsigned long int);
  void refresh_screen(void);
  void init_edit(void);
  void read_file(boolean, char *);
  void write_file(void);
  void my_ed_open(char *, int, int, int);
  void my_ed_init(void);
  void my_ed_close(void);
  void save_file(void);
  void insert_file(void);
  void print_file(void);
  void shift_left(void);
  void shift_right(void);
  void insert_latex_string(int);
  void init_menu(void);
  void split_screen(boolean);
  void mid_line(int, boolean);
  void split_cursor(token, direction);
  void other_window(void);
  void reverse_lines(void);
  void toggle_joint_cursor(void);
  boolean inserting(void);

