#include <string.h>
#include <conio.h>
#include "global.h"
#include "LATEX.h"

#ifndef TEX
void init_menu(void) {}
#else
#define  FORE_COLOR    BLUE         /*Colors for menu*/
#define  BACK_COLOR    GREEN
#define  MENU_ROW      3            /*Menu start row*/
#define  MENU_COL      10           /*Menu start column*/
#define  MENU_LENGTH   18           /*Menu number of rows*/
#define  COLUMNS       4            /*Number of columns of strings*/
#define  COL_SPACE     15           /*Width of each column*/
#define  LATEX_WIDTH   21           /*Width of latex string*/
#define  NAME_LEN  (MENU_LENGTH*COLUMNS-1) /*Number of names in a menu*/

typedef char col_string[COL_SPACE];
typedef char latex_string[LATEX_WIDTH];
typedef char *latex_table[];
typedef enum {cont,escape,select} action;/*Action upon key pressed in menu*/

static char   names[NAME_LEN][COL_SPACE];/*Strings actually displayed */
static int    offset;                    /*Offset of strings in array */
static int    save_offsets[10];          /*Save offsets between calls */
static char   search_str[LATEX_WIDTH];   /*Search string saved */
static char   blanks[COL_SPACE+1];
static char   save_letter;
static int    first_letter;

static char   *short_latex[10] =
  {"\\item ", "\\e{}",
   "\\begin{teach}{}\n\n\\end{teach}", "\\p{}", "~\\ref{}",
   "\\begin{prog}\n\n\\end{prog}",
   "\\begin{ques}\n\n\\end{ques}\n\n\\begin{ans}\n\n\\end{ans}",
   "\\index{}", "\\L{}", "\\R{}"};
static int    short_cursor[10] =
  {0, 1, 14, 1, 1, 11, 35, 1, 1, 1};

static void my_ed_read_keycode(int *key)
{
   boolean pressed;
  do get_key(key, &pressed, FALSE); while (!pressed);
}

static void write_list(void)
{
    int r, c;
  for (r = 0; r <= MENU_LENGTH-1; r++)
    for (c = 0; c <= COLUMNS-1; c++)  {
      gotoxy(c * COL_SPACE+2, r+2);
      cputs(blanks);
      gotoxy(c * COL_SPACE+2, r+2);
      cputs(names[r * COLUMNS + c]);
    }
}

static void set_list(latex_table l_strings, int n)
/*
   Starting from offset, copy a sequence of latex strings
     to the array names.
   Blank unused entries as well as last character of each string.
*/
{
    int i;
  for (i = 0; i <= NAME_LEN; i++)
    if (i+offset <= n) {
      strncpy(names[i], l_strings[offset+i], COL_SPACE-1);
      names[i][COL_SPACE] = 0;
    }
    else strset(names[i], ' ');
}

static void reset_list(
    int off,
    latex_table l_strings,
    int n,
    int *nextrow,
    int *nextcol)
/*
  Given a new offset off, reset offset and return new rol and col.
  Complexity because there might not remain enough strings to
  fill the names array.
*/
{
    int last;            /*Index of last string which will fill names*/
    int delta;           /*Difference between offset and last*/
      last = n - NAME_LEN;
      delta = 0;
      if (off < 0) offset = 0;
      else if ((last < 0)  && (off > n))      /*Not enough names*/
	{ delta = n; offset = 0; }
      else if ((last >= 0) && (off > last))  /*Offset within last strings*/
	  { delta = off - last; offset = last; }
      else
	  offset = off;
      set_list(l_strings, n);
      write_list();
      *nextrow = delta / COLUMNS;
      *nextcol = delta % COLUMNS;
}

boolean is_alpha(char c)
{
  return ((c >= 'A') && (c <= 'Z')) || ((c >= 'a') && (c <= 'z'));
}

static void trylist(
    int key,
    latex_table l_strings,
    int n,
    int *nextrow,
    int *nextcol)
/*
  Given a letter key, set new menu and return row and col
  such that first string starting with key is at the top.
  Skip over preceeding punctuation, e.g. \.
*/
{
      int i, j;
      latex_string s;
    for (i = 0; i <= n; i++) {
      strcpy(s, l_strings[i]);
      j = 0;
      while ((!is_alpha(s[j])) && (j < LATEX_WIDTH)) j++;
      if ((char) key == s[j])
	{ reset_list(i, l_strings, n, nextrow, nextcol); goto out; }
    }
out:;
}

static void search(
    boolean anchor,
    latex_table l_strings,
    int n,
    int row,
    int col,
    int *nextrow,
    int *nextcol)
/*
  Search for the first occurence of (global variable) search_str,
  starting just past the current cursor location which is defined
  by offset, row and col.
*/
{
      int i;
      char *ptr;
    if (search_str != "")
      for (i = offset + row * COLUMNS + col + 1; i <= n; i++)
      	if (strstr(l_strings[i], search_str) != 0) {
      	  ptr = strstr(l_strings[i], search_str);
          if (  (!anchor) || (ptr == l_strings[i]) ) {
    	    reset_list(i, l_strings, n, nextrow, nextcol);
            goto out;
          }
        }
out:;
}

static void next_position(
    latex_table l_strings,
    int n,
    int row,
    int *nextrow,
    int col,
    int *nextcol,
    action *a)
/*
  Starting from current position (row, col), read a key and compute
  the new position (nextrow, nextcol).
  Pressing esc or cr will return a final action a, otherwise continue.
*/
{
    int TWO_THIRDS = 2 * NAME_LEN / 3;
    int key;
    int r, c;                  /*Call reset without changing nextrow/col*/
    char s[LATEX_WIDTH+2];     /*For cgets*/
  my_ed_read_keycode(&key);
  *a       = cont;             /*Default values for a, nextrow, nextcol*/
  *nextrow = row;
  *nextcol = col;
  if ((key > 255) && (first_letter > 0)) {
    if (key == ed_del_back) {
      first_letter--;
      reset_list(0, l_strings, n, nextrow, nextcol);
    }
    else first_letter = 0;
  }
  switch (key) {
    case ed_esc:       *a = escape; break;
    case ed_new_line:  *a = select; break;
    case ed_back:
      if (col == 0) *nextcol = COLUMNS - 1; else *nextcol = col - 1;
      break;
    case ed_for:
      if (col == COLUMNS - 1) *nextcol = 0; else *nextcol = col + 1;
      break;
    case ed_up:
      if (row == 0) reset_list(offset-COLUMNS,l_strings,n,&r,&c);
      else *nextrow = row - 1;
      break;
    case ed_down:
      if (row == MENU_LENGTH-1) 
        reset_list(offset+COLUMNS,l_strings,n,&r,&c);
      else *nextrow = row + 1;
      break;
    case ed_end:    *nextcol = COLUMNS - 1; break;
    case ed_home:   *nextcol = 0; break;
    case ed_scrn_down:
      *nextrow = MENU_LENGTH-1; *nextcol = COLUMNS-1; break;
    case ed_scrn_up:
      *nextrow = 0; *nextcol = 0; break;
    case ed_top:    
      reset_list(0, l_strings, n, nextrow, nextcol); 
      break;
    case ed_bottom: 
      reset_list(n, l_strings, n, nextrow, nextcol); 
      break;
    case ed_pgup:   
      reset_list(offset-TWO_THIRDS, l_strings, n, nextrow, nextcol); 
      break;
    case ed_pgdn:   
      reset_list(offset+TWO_THIRDS, l_strings, n, nextrow, nextcol); 
      break;
    case ed_search:
      gotoxy(2, 2);
      cputs(blanks); cputs(blanks); cputs(blanks); cputs(blanks);
      gotoxy(2, 2);
      cputs("Search for: ");
      s[0] = (char) LATEX_WIDTH;
      cgets(s);
      strcpy(search_str, &s[2]);
      reset_list(offset, l_strings, n, &r, &c);  /*Restore after prompt*/
      search(FALSE, l_strings, n, row, col, nextrow, nextcol);
      break;
    case ed_again:
      search(FALSE, l_strings, n, row, col, nextrow, nextcol); break;
    default:
      if (first_letter == 0) {
        if (key != ed_del_back) {
          trylist(key, l_strings, n, nextrow, nextcol);
          save_letter = key;
          first_letter++;
        }
      }
      else {
        if (first_letter == 1) search_str[0] = save_letter;
        if (key != ed_del_back) search_str[first_letter++] = key;
        search_str[first_letter] = 0;
        search(TRUE, l_strings, n, row, col, nextrow, nextcol);
      }
      break;
  }
     /*Catch cursor movements beyond } of names in menu*/
  if ((offset + *nextrow * COLUMNS + *nextcol) > n) {
    *nextrow = (n-offset) / COLUMNS;
    *nextcol = (n-offset) % COLUMNS;
  }
}

static void menu_bar(int row, int col, int nextrow, int nextcol)
/*
  Reset (row, col) to normal color,
  and reverse colors of (nextrow, nextcol).
*/
{
  gotoxy(col * COL_SPACE+2, row+2);
  cputs(blanks);
  gotoxy(col * COL_SPACE+2, row+2);
  cputs(names[row * COLUMNS+col]);
  set_colors(BACK_COLOR, FORE_COLOR);
  gotoxy(nextcol * COL_SPACE+2, nextrow+2);
  cputs(blanks);
  gotoxy(nextcol * COL_SPACE+2, nextrow+2);
  cputs(names[nextrow * COLUMNS+nextcol]);
  set_colors(FORE_COLOR, BACK_COLOR);
  gotoxy(nextcol * COL_SPACE+2, nextrow+2);
}

static void send_string(char *s)
{
   int i;
  for (i = 0; i < strlen(s); i++) 
    if (s[i] == '\n') new_line(); else insert_char(s[i], FALSE);
}

static void insert_string(
    int code,
    latex_table l_strings,
    int choice,
    int *brace)
/*
  Insert latex string: code is the table and choice is index within table.
  Brace is the location of the first brace or bracket for setting cursor.
*/
{
    int b;
    latex_string s;
  strcpy(s, l_strings[choice]);
  switch (code) {
    case 2:
       send_string("\\begin{");
       send_string(s);
       send_string("}");
       new_line();
       new_line();
       send_string("\\end{");
       send_string(s);
       send_string("}");
       b = 1;
       break;
    case 1: case 3: case 4: case 5:
       if (code == 1) send_string("\\");
       send_string(s);
       b = 0;
       while ( (b < strlen(s)) && (s[b] != '}') ) b++;
       b = strlen(s) - b;
       break;
    default:  break;
  }
  *brace = b;
}

static void make_menu(
    int code,
    latex_table l_strings,
    int n,
    int *brace)
/*
  Make menu and call next_position repeated until select or escape.
  code, l_strings, n are the latex table data passed to other procedures.
  brace is returned for cursor movement.
*/
{
    action a;
    int row, nextrow;
    int col, nextcol;

  offset = save_offsets[code];
  window(MENU_COL-1,
     MENU_ROW-1,
     MENU_COL+COLUMNS * COL_SPACE,
     MENU_ROW+MENU_LENGTH+1);
  set_colors(FORE_COLOR, BACK_COLOR);
  write_frame(1, 1, COLUMNS * COL_SPACE + 2, MENU_LENGTH+2);
  if (offset > n) offset = 0;
  row     = 0;
  nextrow = 0;
  col     = 0;
  nextcol = 0;
  set_list(l_strings, n);
  write_list();
  do {
    menu_bar(row, col, nextrow, nextcol);
    row = nextrow;
    col = nextcol;
    next_position(l_strings, n, row, &nextrow, col, &nextcol, &a);
  } while (a == cont);
  create_edit_window();
/*  restore_status();  */
  refresh_screen();
  if (a == select) {
    offset += row * COLUMNS + col;
    save_offsets[code] = offset;
    insert_string(code, l_strings, offset, brace);
  }
  else *brace = 0;
}

void insert_latex_string(int key)
/*
  Interface procedure called with the key pressed:
    ed_latex_n, n = 1..10. (Currently 1..5 used).
  Call make_menu, then restore edit window and do cursor movements.
*/
{
   int i;
   int off;
   int brace;
/*  save_status(); */
  switch (key) {
    case ed_latex_1: make_menu(1, l_str, l_len, &brace); break;
    case ed_latex_2: make_menu(2, e_str, e_len, &brace); break;
    case ed_latex_3: make_menu(3, p_str, p_len, &brace); break;
    case ed_latex_4: make_menu(4, s_str, s_len, &brace); break;
    case ed_latex_5: make_menu(5, b_str, b_len, &brace); break;
    case ed_latex_11: case ed_latex_12: case ed_latex_13:
    case ed_latex_14: case ed_latex_15: case ed_latex_16:
    case ed_latex_17: case ed_latex_18: case ed_latex_19:
    case ed_latex_20:
      off = key - ed_latex_11;
      send_string(short_latex[off]);
      for (i = 1; i <= short_cursor[off]; i++) move_cursor(ch, back);
    default: break;
  }
  if (brace != 0)
    switch (key) {
      case ed_latex_2: move_cursor(lin, back); move_cursor(ch, up); break;
      case ed_latex_1: case ed_latex_3: case ed_latex_4: case ed_latex_5:
	for (i = 1; i <= brace; i++) move_cursor(ch, back);
	break;
      default: break;
    }
}

void init_menu(void)
{
  int i;
  strcpy(blanks, "               ");
  strcpy(search_str, "");
  for (i = 0; i < 10; i++) save_offsets[i] = 0;
  offset = 0;
  first_letter = 0;
}

#endif

