#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <alloc.h>
#include "global.h"

static str_rec search_str;
static str_rec replace_str;

static void replace(void)
{
    int i;
  get_string(replace_p_1, &search_str);
  for (i = 0; i < search_str.len; i++)
    search_str.s[i] = to_upper(search_str.s[i]);
  get_string(replace_p_2, &replace_str);
  replace_string(search_str.s,  search_str.len,
		 replace_str.s, replace_str.len);
}

static void search(boolean again)
{
  boolean found;
  int i;

  found = FALSE;
  if (!again) {
    get_string(search_p, &search_str);
    search_str.s[search_str.len] = '\0';
    if (! rtl())
      for (i=0; i<search_str.len; i++)
        search_str.s[i] = toupper(search_str.s[i]);
  }
  search_string(search_str.s, search_str.len, again, &found);
}

void cursor_to_line(void)
{
  int i;
  get_integer(line_p, &i);
  cursor_to_line_number(i);
}

void main_loop(void);

void key_command(int key, boolean *contin)
{
  long int mem;
  int i;
  switch (key) {
    case ed_new_line:
      new_line(); break;
    case ed_home:
      move_cursor(lin, back); break;
    case ed_back:
      if (rtl())  move_cursor(ch,  forwrd);
	  else move_cursor(ch,  back);
	  break;
    case ed_word_back:
      if (rtl())  move_cursor(wrd, forwrd);
	  else move_cursor(wrd, back);
	  break;
    case ed_end:
      move_cursor(lin, forwrd); break;
    case ed_for:
      if (rtl())  move_cursor(ch,  back);
	  else move_cursor(ch,  forwrd);
	  break;
    case ed_word_for:
      if (rtl())  move_cursor(wrd, back);
	  else move_cursor(wrd, forwrd);
	  break;
    case ed_scrn_up:    move_cursor(scrn, up);   break;
    case ed_scrn_down:  move_cursor(scrn, down); break;
    case ed_up:         split_cursor(ch, up);    break;
    case ed_down:       split_cursor(ch, down);  break;
    case ed_pgup:       split_cursor(pg, up);    break;
    case ed_pgdn:       split_cursor(pg, down);  break;
    case ed_top:        split_cursor(txt, up);   break;
    case ed_bottom:     split_cursor(txt, down); break;
    case ed_goto_line:  cursor_to_line();        break;
    case ed_del_line:   delete(lin, up);         break;
    case ed_del_w_for:  delete(wrd, forwrd);     break;
    case ed_del_l_for:  delete(lin, forwrd);     break;
    case ed_del_w_back: delete(wrd, back);       break;
    case ed_del_l_back: delete(lin, back);       break;
    case ed_del_for:    delete(ch, forwrd);      break;
    case ed_del_back:
      if (ltr())  delete(ch, forwrd);
      else delete(ch, back);
      break;
    case ed_rtl:
      change_language();
      create_edit_window();
      refresh_screen();
      break;
    case ed_ltr:        toggle_ltr();  break;
    case ed_mark:       mark_block();  break;
    case ed_copy:       
      mem = coreleft() - 500L;
      cut_copy_block(TRUE, mem);
      break;
    case ed_cut:        
      mem = coreleft() - 500L;
      cut_copy_block(FALSE, mem);   
      break;
    case ed_paste:      
      mem = coreleft() - 500L;
      paste_block(mem); 
      break;
    case ed_search:     search(FALSE); break;
    case ed_again:      search(TRUE);  break;
    case ed_replace:    replace();     break;
    case ed_help:
      display_help();
      wait_key(&i);
      refresh_screen();
      break;
    case ed_view:
      if (!inserting()) {
	my_ed_open("", 0, 1, FALSE);
	move_cursor(txt, up);
	main_loop();
	my_ed_close();
      }
      break;
    case ed_format:     if (!inserting()) format_file(); break;
    case ed_print:      if (!inserting()) print_file();  break;
    case ed_new_file:
      if (!inserting()) {
	if (confirm()) {
	  save_file();
	  my_ed_close();
	  my_ed_open("", 0, 1, FALSE);
	} else refresh_screen();
      }
      break;
    case ed_insert:
      if (!inserting()) {insert_file(); split_screen(TRUE);}
      break;
    case ed_save: /* if (!inserting()) */ save_file(); break;
    case ed_exit:
      if (!inserting()) {write_file();  *contin = FALSE;}
      break;
    case ed_quit:
      if (!inserting()) {
	if (confirm()) *contin = FALSE;
	else refresh_screen();
      }
      break;
    case ed_shift_left:
      if (rtl()) shift_right(); else shift_left();  break;
    case ed_shift_right:
      if (rtl()) shift_left();  else shift_right(); break;
    case ed_esc:         cancel_command();     break;
    case ed_split:       split_screen(TRUE);   break;
    case ed_join_cursor: toggle_joint_cursor();break;
    case ed_reverse:     reverse_lines();      break;
    case ed_window:      other_window();       break;

    case ed_latex_1: case ed_latex_2: case ed_latex_3: case ed_latex_4:
    case ed_latex_5: case ed_latex_6: case ed_latex_7: case ed_latex_8:
    case ed_latex_9: case ed_latex_10:
    case ed_latex_11: case ed_latex_12: case ed_latex_13:
    case ed_latex_14: case ed_latex_15: case ed_latex_16:
    case ed_latex_17: case ed_latex_18: case ed_latex_19:
    case ed_latex_20:
      if (!inserting()) insert_latex_string(key); break;
    case ed_undefined:
      break;
    default:
      exit(EXIT_FAILURE);
  }
}

void mouse_command(int r1, int c1, int button)
{
  int r2, c2, button2, ok;
  long int mem;

  mouse_sync(r1, c1, &ok);
  if (button == 2) {          /*Right button*/
    mark_block();             /*Mark block*/
    do {
      mouse_get(&r2, &c2, &button2);
      mouse_sync(r2, c2, &ok);
    } while (button2 != 0);
    mouse_off();              /*Turn off mouse cursor during processing*/
    mem = coreleft() - 500L;
    cut_copy_block(TRUE, mem);     /*Copy block at location of release*/
  }
  else if ((button == 3) || (button == 4)) {
      /*Middle or both buttons*/
    mouse_released(&r2, &c2);
    mouse_off();
    mem = coreleft() - 500L;
    paste_block(mem);
  }
  else mouse_released(&r2, &c2);
  mouse_on();
}

void main_loop(void)
{
    int key;                /*Key code pressed*/
    int r, c;               /*Mouse location*/
    int button;             /*Mouse button pressed*/
    boolean contin;         /*Continue flag, reset by interpret_key to stop*/
    boolean pressed;

  contin = TRUE;
  do {
    mouse_on();
    get_key(&key, &pressed, TRUE);
    if (pressed) {
      mouse_off();                      /*Turn off mouse while processing*/
      if (coreleft() < 1000L) bell();
      if (key <= 256) insert_char(key, ltr()); /*Printable characters*/
      else key_command(key, &contin);   /*Edit commands*/
      mouse_on();
    }
    else {
      mouse_get(&r, &c, &button);       /*Get current state of mouse*/
      if (button != 0)                  /*button = 0 means none pressed*/
        mouse_command(r, c, button);
    };
  } while (contin);
}

int main(int argc, char *argv[])
{ /*Main program*/
  char s[40];

  search_str.len  = 0;
  replace_str.len = 0;
  init_display1();
  my_ed_init();
  init_menu();
  if (argc > 1) strcpy(s, argv[1]); else strcpy(s, "");
  clear_screen(fore_color, back_color);
/*
  mouse_init();
*/
/*
  write_help_lines();
*/
  create_edit_window();
  my_ed_open(s, 0, 1, FALSE);
  move_cursor(txt, up);
  main_loop();
  if (rtl())  change_language();    /*Restore left-to-right before exit*/
  clear_screen(LIGHTGRAY, BLACK);
  return 0;
}

