#include <ctype.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "global.h"

#define   bs        8
#define   tab       9
#define   cr       13
#define   shtab    15
#define   esc      27
#define   home     71
#define   up       72
#define   pgup     73
#define   left     75
#define   right    77
#define   endd     79
#define   down     80
#define   pgdn     81
#define   ins      82
#define   del      83
#define   c_left   115
#define   c_right  116
#define   c_endd   117
#define   c_pgdn   118
#define   c_home   119
#define   c_pgup   132
#define   S_MAX             25
#define   MICKEY_HORIZONTAL  8
#define   MICKEY_VERTICAL    16
#define   MOUSE_SPEED        64
#define   PIXELS        8
#define   LEFT_UPPER  218
#define   RIGHT_UPPER 191
#define   LEFT_LOWER  192
#define   RIGHT_LOWER 217
#define   LEFT_TEE    195
#define   RIGHT_TEE   180
#define   HORIZ_CHAR  196
#define   VERT_CHAR   179

#define fhs1  "Punc"
#define fhs2  "Mark"
#define fhs3  "DWF "
#define fhs4  "DLin"
#define fhs5  "Env "
#define fhs6  "Src "
#define fhs7  "Styl"
#define fhs8  "Save"
#define fhs9  "Com "
#define fhs10 "Exit"
#define shs1  "item"
#define shs2  "em  "
#define shs3  "tech"
#define shs4  "sf  "
#define shs5  "ref "
#define shs6  "prog"
#define shs7  "ques"
#define shs8  "indx"
#define shs9  "\L  "
#define shs10 "\R  "
#define chs1  "Help"
#define chs2  "Copy"
#define chs3  "DWB "
#define chs4  "DLF "
#define chs5  "Cut "
#define chs6  "Src*"
#define chs7  "Othr"
#define chs8  "IncF"
#define chs9  "Rplc"
#define chs10 "Quit"
#define ahs1  "Sh-L"
#define ahs2  "Sh-R"
#define ahs3  "Splt"
#define ahs4  "DLB "
#define ahs5  "Join"
#define ahs6  "GoLn"
#define ahs7  "Rev "
#define ahs8  "New "
#define ahs9  "Form"
#define ahs10 "View"

#define fhl1  "Punctuation"
#define fhl2  "Mark block"
#define fhl3  "Delete word fwd"
#define fhl4  "Delete line"
#define fhl5  "Environments"
#define fhl6  "Search"
#define fhl7  "Styles"
#define fhl8  "Save text"
#define fhl9  "Commands"
#define fhl10 "Exit, save text"

#define shl1  "item"
#define shl2  "emphasize"
#define shl3  "teacher"
#define shl4  "sans serif"
#define shl5  "reference"
#define shl6  "Program"
#define shl7  "question/answer"
#define shl8  "index"
#define shl9  "English insert"
#define shl10 "Hebrew insert"

#define chl1  "Display help"
#define chl2  "Copy block"
#define chl3  "Delete word back"
#define chl4  "Delete line fwd"
#define chl5  "Cut block"
#define chl6  "Search again"
#define chl7  "Other window"
#define chl8  "Include file"
#define chl9  "Replace"
#define chl10 "Quit, no save"

#define ahl1  "Shift text left"
#define ahl2  "Shift text right"
#define ahl3  "Split screen"
#define ahl4  "Delete line back"
#define ahl5  "Join cursors"
#define ahl6  "Go to line number"
#define ahl7  "Reverse text"
#define ahl8  "New file"
#define ahl9  "Format text"
#define ahl10 "View text"

typedef unsigned int word;

typedef struct {
  int key;
  char *short_help;
  char *long_help;
  } key_struc;

static key_struc function_keys[] = {
     {ed_latex_3,    fhs1,  fhl1},
     {ed_mark,       fhs2,  fhl2},
     {ed_del_w_for,  fhs3,  fhl3},
     {ed_del_line,   fhs4,  fhl4},
     {ed_latex_2,    fhs5,  fhl5},
     {ed_search,     fhs6,  fhl6},
     {ed_latex_4,    fhs7,  fhl7},
     {ed_save,       fhs8,  fhl8},
     {ed_latex_1,    fhs9,  fhl9},
     {ed_exit,       fhs10, fhl10},
     {ed_latex_11,   shs1,  shl1},
     {ed_latex_12,   shs2,  shl2},
     {ed_latex_13,   shs3,  shl3},
     {ed_latex_14,   shs4,  shl4},
     {ed_latex_15,   shs5,  shl5},
     {ed_latex_16,   shs6,  shl6},
     {ed_latex_17,   shs7,  shl7},
     {ed_latex_18,   shs8,  shl8},
     {ed_latex_19,   shs9,  shl9},
     {ed_latex_20,   shs10, shl10},
     {ed_help,       chs1,  chl1},
     {ed_copy,       chs2,  chl2},
     {ed_del_w_back, chs3,  chl3},
     {ed_del_l_for,  chs4,  chl4},
     {ed_cut,        chs5,  chl5},
     {ed_again,      chs6,  chl6},
     {ed_window,     chs7,  chl7},
     {ed_insert,     chs8,  chl8},
     {ed_replace,    chs9,  chl9},
     {ed_quit,       chs10, chl10},
     {ed_shift_left, ahs1,  ahl1},
     {ed_shift_right,ahs2,  ahl2},
     {ed_split,      ahs3,  ahl3},
     {ed_del_l_back, ahs4,  ahl4},
     {ed_join_cursor,ahs5,  ahl5},
     {ed_goto_line,  ahs6,  ahl6},
     {ed_reverse,    ahs7,  ahl7},
     {ed_new_file,   ahs8,  ahl8},
     {ed_format,     ahs9,  ahl9},
     {ed_view,       ahs10, ahl10},
  };

static  char *prompt_strings[] = {
      "File name:",  "Search for:",      "Replace:", "With:",
      "Go to line:", "Yes/No/Quit/All:", "Type Yes to confirm:"
      };

static  char *rtl_prompt_strings[] = {
      ":",      ": ",     ": ", ":",
      ": ", ":///", ":  "
      };

static  char *help_screen[] =
{
"\r\n     Function key      Shift key         Control key       Alt key\r\n",
"Cursor Movement   Char.    Word    Line   Row    Screen   Page   Text\r\n",
"Forwards/End:     Right   C-Right  End    Down   C-End    PgDn   C-PgDn\r\n",
"Backwards/Start:  Left    C-Left   Home   Up     C-Home   PgUp   C-PgUp\r\n",
"Mouse:  Left = Move cursor,   Middle = Paste,   Right = Mark block\r\n",
"         (c) 1993-94 Mavo Software Ltd. All rights reserved."
};

static char  answer_chars[]     = {'Y', 'N', 'A', 'Q'};
static char  rtl_answer_chars[] = {'', '', '', ''};

static boolean rtl_flag;
static boolean ltr_flag;
static word rega, regb, regc, regd;
static boolean mouse_exists;

static int table[26] =
  {153, 144, 129, 130, 151, 139, 146, 137, 143, 135, 140, 138, 150,
   142, 141, 148,  47, 152, 131, 128, 133, 132,  39, 145, 136, 134};

static void translate(char c, int *i) {*i = table[c - 'a'];}
void set_rtl(boolean b) {rtl_flag = b;}
boolean rtl(void) {return rtl_flag;}
boolean ltr(void){return ltr_flag;}
void toggle_ltr(void) {ltr_flag = ! ltr_flag;}
void full_screen(void) {window(1, 1, 80, 25);}
void clear_line(void) {clreol();}
void bell(void) {putch('\a');}

void set_colors(int fore, int back)
{
  textcolor(fore);
  textbackground(back);
}

void clear_screen(int fore, int back)
{
  full_screen();
  set_colors(fore, back);
  clrscr();
}

void erase(int r)
{
  int i;
  for (i = r; i <= ROW_MAX; i++) {
    gotoxy(1, i+1);
    clreol();
  }
}

void extend_window(void)
{
    struct text_info ti;
  window(EDIT_COL_START,   EDIT_ROW_START,
	 EDIT_COL_END,     EDIT_ROW_END+1);
  gotoxy(1, ROW_MAX+2);
  gettextinfo(&ti);
  if ((ti.attribute & 7) == back_color) {
    set_colors(fore_color, back_color);
    clear_line();
    set_colors(back_color, fore_color);
  }
  else clear_line();
}

void scroll_up(void)
{
  gotoxy(1, 1);
  delline();
/* if (rtl_flag) */
  extend_window();
}

void scroll_down(void)
{
  gotoxy(1, 1);
  insline();
/* if (rtl_flag) */
  extend_window();
}


void line_ver(int y1, int y2, int x)
{
  int y;
  for (y = y1; y <= y2; y++) {gotoxy(x, y); putch(VERT_CHAR);}
}

void line_hor(int x1, int x2, int y)
{
  int x;
  for (x = x1; x <= x2; x++) {gotoxy(x, y); putch(HORIZ_CHAR);}
}

void mid_line(int y, boolean draw)
{
  full_screen();
  if (draw) {
    gotoxy(EDIT_COL_START-1, y+1); putch(LEFT_TEE);
    gotoxy(EDIT_COL_END+1,   y+1); putch(RIGHT_TEE);
  } else {
    gotoxy(EDIT_COL_START-1, y+1); putch(VERT_CHAR);
    gotoxy(EDIT_COL_END+1,   y+1); putch(VERT_CHAR);
  }
  window(EDIT_COL_START,   EDIT_ROW_START,
	 EDIT_COL_END,     EDIT_ROW_END+1);
  line_hor(EDIT_COL_START-1, EDIT_COL_END-1, y);
}

void write_frame(int x1, int y1, int x2, int y2)
{
  gotoxy(x1, y1); putch(LEFT_UPPER);
  gotoxy(x2, y1); putch(RIGHT_UPPER);
  line_ver(y1+1, y2-1, x1);
  line_ver(y1+1, y2-1, x2);
  line_hor(x1+1, x2-1, y1);
  if (y2 != 25) {
    line_hor(x1+1, x2-1, y2);
    gotoxy(x2, y2); putch(RIGHT_LOWER);
    gotoxy(x1, y2); putch(LEFT_LOWER);
  }
}

void create_edit_window(void)
{
/*  write_help_lines();*/
  set_colors(fore_color, back_color);
  full_screen();
  write_frame(EDIT_COL_START-1, EDIT_ROW_START-1,
	      EDIT_COL_END+1,   EDIT_ROW_END+1);
  extend_window();
/*
  if (rtl_flag) extend_window();
  else window(EDIT_COL_START,   EDIT_ROW_START,
	      EDIT_COL_END,     EDIT_ROW_END);
*/
}

static void my_readln(str_rec *str, int c, int row)
{
  int     i;            /*Character counter*/
  int     key = 0;          /*Key code returned*/
  int     prefix_len = str->len;
  int     prefix_index = 0;

  i = 0;
  do {
    if ((key == ed_home) && (i > 0)) {}
    else if (prefix_index < prefix_len)
      key = str->s[prefix_index++];
    else wait_key(&key);
    if ((key < 256) && (i < S_MAX)) { /*Printable and room in window*/
      str->s[i] = key;                /*Insert key in string*/
      i++;
      putch(key);                     /*Echo to screen*/
      if (rtl_flag) gotoxy(c-i, row);   /*Return after writing*/
    }
    else if (( (key == ed_del_back) || (key == ed_home) ) && (i > 0)) {
				      /*BS and characters in window*/
      i--;                            /*Enough to change string index*/
      if (rtl_flag) gotoxy(c-i, row); else gotoxy(c+i, row);
      putch(' ');                     /*Blank out character*/
      if (rtl_flag) gotoxy(c-i, row); else gotoxy(c+i, row);
    }				      /*Reset cursor*/
  } while ((key != ed_new_line) && (key != ed_esc));
	  /*Carriage return or escape terminates*/
  if (key == ed_esc) str->len = 0;    /*Escape cancels*/
  else str->len = i;                  /*Return valid length*/
}

#ifdef displayhelplines

void get_string(prompts p, str_rec *result)
{
  int prompt_len;    /*Length of prompt string*/
  int start_col;     /*Start column for window*/
  int end_col;       /*End column for window*/
  int string_col;    /*Column where the entered string starts*/

  if (rtl_flag) prompt_len = strlen(rtl_prompt_strings[p]);
  else          prompt_len = strlen(prompt_strings[p]);
    /*Center the window. The term 3 is: */
    /*  two columns for vertical lines plus a space after the prompt*/
  start_col = (80 - prompt_len - S_MAX - 3) / 2;
  end_col   = start_col + prompt_len + S_MAX + 3;
    /*Prepare window*/
  set_colors(fore_color, back_color);
  full_screen();
  write_frame(start_col, 23, end_col, 25);
  window(start_col+1, 24, end_col-1, 24);
  erase(0);

  if (rtl_flag) {                 /*Write prompt at end of window*/
    string_col = end_col - start_col - prompt_len - 3;
    gotoxy(string_col + 2, 1);    /*Go to start of prompt string*/
  }
  else                            /*Otherwise just leave space after prompt*/
    string_col = prompt_len + 2;
  if (rtl_flag) cputs(rtl_prompt_strings[p]);
  else          cputs(prompt_strings[p]);

  gotoxy(string_col, 1);          /*Set cursor to receive input*/
  my_readln(result, string_col);
  create_edit_window();           /*Restore edit frame and window*/
}

#endif

void get_string(prompts p, str_rec *result)
{
  int prompt_len;    /*Length of prompt string*/
  int prompt_col;    /*Column for prompt sting*/

  if (rtl_flag) {
    prompt_len = strlen(rtl_prompt_strings[p]);
    prompt_col = 80 - prompt_len;
  }
  else {
    prompt_len = strlen(prompt_strings[p]);
    prompt_col = 2;
  }
  set_colors(fore_color, back_color);
  full_screen();
  gotoxy(prompt_col, 25);
  if (rtl_flag) {
    cputs(rtl_prompt_strings[p]);
    prompt_col -= 2;
  }
  else {
    cputs(prompt_strings[p]);
    prompt_col += prompt_len+1;
  }
  gotoxy(prompt_col, 25);
  my_readln(result, prompt_col, 25);
  gotoxy(1, 25);
  clear_line();
  create_edit_window();
}

void get_integer(prompts p, int *result)
{
  str_rec str;                 /*For get_string result*/
  int     num;                 /*Value computed*/
  int     i;                   /*String index*/

  str.len = 0;
  get_string(p, &str);
  i = 0;
  num = 0;
  while ((i < str.len) && ('0' <= str.s[i]) && (str.s[i] <= '9')) {
    num = num * 10 + (str.s[i] - ('0'));
    i++;
  }
  *result = num;
}

boolean compare_answer(answers a, str_rec str)
{
  if (str.len == 0) return a == quit_a;
  else if (rtl_flag) return str.s[0] == rtl_answer_chars[a];
  else               return toupper(str.s[0]) == answer_chars[a];
}

void get_answer(int *a)
{
    str_rec str;
    int  i, t, l;
    char c[2];
  str.len = 0;
  l = EDIT_COL_START + wherex() - 1;
  t = EDIT_ROW_START + wherey() - 1;
  gettext(l, t, l, t, c);
  c[1] = ((fore_color & 7) << 4) + back_color;
  puttext(l, t, l, t, c);
  do {
    get_string(confirm_p, &str);
    if (str.len == 0) {i = quit_a; goto out;}
    else if (rtl_flag) {
      for (i = 0; i <= quit_a; i++)
	if (str.s[0] == rtl_answer_chars[i]) goto out;
    }
    else
      for (i = 0; i <= quit_a; i++)
	if (toupper(str.s[0]) == answer_chars[i]) goto out;
  } while (TRUE);
out:
  c[1] = (back_color << 4) + fore_color;
  puttext(l, t, l, t, c);
  *a = i;
}

boolean confirm(void)
{
  str_rec str;
  str.len = 0;
  get_string(quit_p, &str);
  return compare_answer(yes_a, str);
}

void change_language(void)
{
  rtl_flag = ! rtl_flag;
  ltr_flag = FALSE;                /*Reset ltr flag in any case*/
/*  if (rtl_flag) */
  extend_window();
/*  pokeb(peek(0x0, 0x42), 6, rtl_flag);*/
}

void init_display1(void)
{
  directvideo = 1;
  rtl_flag = FALSE;
  ltr_flag = FALSE;
}

void get_key(int *key_code, boolean *pressed, boolean check_rtl)
{
    int  first;
    int  extend;
    int  key;

  *pressed = kbhit();
  if (*pressed) {
  first = getch();
  if (first >= ' ') {
    if (check_rtl &&
        ((rtl_flag && !ltr_flag) || (!rtl_flag && ltr_flag))) {
      if ((first >= 'a') && (first <= 'z')) translate(first, &key);
      else if (first == '.')  key = 149;
      else if (first == ',')  key = 154;
      else if (first == ';')  key = 147;
      else if (first == '/')  key = 46;
      else if (first == '\'') key = 44;
      else key = first;
    }
    else key = first;
  }
  else if (first == bs)    key = ed_del_back;
  else if (first == tab)   key = ed_rtl;
  else if (first == cr)    key = ed_new_line;
  else if (first == esc)   key = ed_esc;
  else if (first != 0)     key = ed_undefined;
  else {
    extend = getch();
    if ((extend >= 59) && (extend <= 68))
      key = function_keys[extend-59].key;
    else if ((extend >= 84) && (extend <= 113))
      key = function_keys[extend-84+10].key;
    else
      switch (extend) {
	case home:    key = ed_home;        break;
	case up:      key = ed_up;          break;
	case pgup:    key = ed_pgup;        break;
	case left:    key = ed_back;        break;
	case right:   key = ed_for;         break;
	case endd:    key = ed_end;         break;
	case down:    key = ed_down;        break;
	case pgdn:    key = ed_pgdn;        break;
	case ins:     key = ed_paste;       break;
	case del:     key = ed_del_for;     break;
	case c_left:  key = ed_word_back;   break;
	case c_right: key = ed_word_for;    break;
	case c_endd:  key = ed_scrn_down;   break;
	case c_pgdn:  key = ed_bottom;      break;
	case c_home:  key = ed_scrn_up;     break;
	case c_pgup:  key = ed_top;         break;
	case shtab:   key = ed_ltr;         break;
	default:      key = ed_undefined;   break;
      }
    }
  }
  *key_code = key;
}

void wait_key(int *i)
{
  boolean pressed;
  do get_key(i, &pressed, TRUE); while (!pressed);
}

void mouse_bios_call(word ra, word rb, word rc, word rd)
{
  asm {
    mov ax,ra
    mov bx,rb
    mov cx,rc
    mov dx,rd
    int 33h
    mov rega,ax
    mov regb,bx
    mov regc,cx
    mov regd,dx
  };
}

void mouse_initialize(word *status)
{
  mouse_bios_call(0, 0, 0, 0);
  *status = rega;
}

void mouse_on()  {if (mouse_exists) mouse_bios_call(1, 0, 0, 0);}
void mouse_off() {if (mouse_exists) mouse_bios_call(2, 0, 0, 0);}

void mouse_get(int *row, int *col, int *buttons)
{
  if (mouse_exists) {
    mouse_bios_call(3, 0, 0, 0);
    *row = regd / PIXELS;
    *col = regc / PIXELS;
    *buttons = regb;
  }  else *buttons = 0;
}

void mouse_set_horizontal(int min, int max)
{
  if (mouse_exists) mouse_bios_call(7, 0, min*PIXELS, max*PIXELS);
}

void mouse_set_vertical(int min, int max)
{
  if (mouse_exists) mouse_bios_call(8, 0, min*PIXELS, max*PIXELS);
}

void mouse_set_mickey_ratio(int horizontal, int vertical)
{
  if (mouse_exists)  mouse_bios_call(15, 0, horizontal, vertical);
}

void mouse_set_speed(int speed)
{
  if (mouse_exists)  mouse_bios_call(19, 0, 0, speed);
}

void mouse_init()
{
     word status;
  mouse_initialize(&status);
  mouse_exists = (status == 65535l);
  mouse_set_mickey_ratio(MICKEY_HORIZONTAL, MICKEY_VERTICAL);
  mouse_set_speed(MOUSE_SPEED);
  mouse_set_horizontal(EDIT_COL_START-1, EDIT_COL_END-1);
  mouse_set_vertical(EDIT_ROW_START-1, EDIT_ROW_END-1);
}

void mouse_released(int *row, int *col)
{
     int r, c, buttons;
  do mouse_get(&r, &c, &buttons); while (buttons != 0);
  *row = r;
  *col = c;
}

void put_help_line(int n) {
    int i;
  if (n == 0)      cputs("  F ");
  else if (n == 1) cputs("  S ");
  else if (n == 2) cputs("  C ");
  else             cputs("  A ");
  for (i = 0; i < 10; i++) {
    if (i == 9) cputs("10"); else putch('1'+i);
    putch('=');
    cputs(function_keys[i+n*10].short_help);
    putch(' ');
  }
}

void write_help_lines(void)
{
  window(1, 24, 80, 25);          /*Set two line window*/
  textcolor(fore_help);           /*Separate colors for help*/
  textbackground(back_help);
  clrscr();                       /*Clear help window*/
  gotoxy(1, 1);                   /*Write the lines*/
  put_help_line(0);
  gotoxy(1, 2);
  put_help_line(1);
}

void display_help(void)
{
  int i;                       /*Help line counter*/
  clrscr();                    /*Clear current screen*/
  cputs("\r\n");
  put_help_line(0);
  cputs("\r\n");
  put_help_line(1);
  cputs("\r\n");
  put_help_line(2);
  cputs("\r\n");
  put_help_line(3);
  cputs("\r\n");
  cputs(help_screen[0]);
  cputs("\r\n");
  for (i = 0; i < 10; i++) {
    if (i == 9) cputs(" 10 "); else {cputs("  "); putch('1'+i); cputs(" ");}
    cprintf(" %-17s %-17s %-17s %-17s",
      function_keys[i].long_help,
      function_keys[i+10].long_help,
      function_keys[i+20].long_help,
      function_keys[i+30].long_help);
    cputs("\r\n");
  }
  cputs("\r\n");
  for (i = 5; i < 6; i++) {cputs("  "); cputs(help_screen[i]);}
}

