/* hanoi.c */
/* Play the good old game of Tower of Hanoi */
/* copyright: K R Nathan, India */

# include <stdio.h>
# include <conio.h>
# include <math.h>

# define MAXDISC 10
# define SLOW 3000
# define FAST 1000
# define FILCHAR 219
# define DELCHAR 32
# define LINCHAR 205

int maxdisc, movfrom, movto, moves, demo, speed ;
int top[4][3] ;
int posx[4] = { 0, 14, 40, 66 } ;
int stakpos[4][MAXDISC + 1] ;

void initvars ( void ) 
{
	int i, j ;

	for ( i = 0 ; i <= 4 ; i++ ) 
		for ( j = 0 ; j <= 3 ; j++ ) 
			top[i][j] = 0 ;
	top[1][1] = 1 ;
	top[1][2] = 1 ;

	for ( i = 0 ; i <= MAXDISC ; i++ ) 
	{
		stakpos[0][i] = 0 ;
		stakpos[1][i] = i ;
		stakpos[2][i] = 0 ;
		stakpos[3][i] = 0 ;
	}

	return ;
}

initscr ( m ) 
int m ;
{
	int i, j, k, x, y ;
	clrscr() ;
	printf ( "\t\t  The Famous Problem of the Tower of Hanoi\n" ) ;

	for ( i = 1 ; i < 80 ; i++ ) 
		printf ( "%c", LINCHAR ) ;
	printf ( "\n\n" ) ;

	for ( i = 1 ; i <= m ; i++ ) 
	{
		y = i + 3 ;
		x = posx[1] - i ;
		gotoxy ( x, y ) ;

		for ( j = 1 ; j <= i * 2 ; j++ ) 
			printf ( "%c", FILCHAR ) ;
	}

	printf ( "\n\n\t  Stack-1\t\t    Stack-2\t\t      Stack-3\n" ) ;

	for ( i = 1 ; i < 80 ; i++ ) 
		printf ( "%c", LINCHAR ) ;
	printf ( "\n\n" ) ;

	if ( demo == 0 ) 
		showrules() ;
	return ;
}

showrules()
{
	int i, j ;
	gotoxy ( 1, 18 ) ;
	printf ( "Task : To transfer the Discs from Stack-1 to Stack-3, one at a time.\n\n" ) ;
	printf ( "Rules : 1. Can remove only the Top Disc from a Stack.\n" ) ;
	printf ( "        2. Can place a Disc only on Top of a Stack.\n" ) ;
	printf ( "        3. A larger Disc cannot be placed upon a smaller Disc.\n" ) ;
	printf ( "        4. Can use Stack-3 as interim space. Above Rules apply.\n\n" ) ;
	printf ( "Press any key to continue ..." ) ;
	getch() ;

	for ( i = 18 ; i <= 25 ; i++ ) 
		for ( j = 1 ; j <= 79 ; j++ ) 
		{
			gotoxy ( j, i ) ;
			printf ( "%c", DELCHAR ) ;
		}

	return ;
}

menu()
{
	int i ;
	clrscr() ;
	printf ( "\t\t\t      Nathan's  'Tower of Hanoi'\n" ) ;

	for ( i = 1 ; i < 80 ; i++ ) 
		printf ( "%c", LINCHAR ) ;
	printf ( "\n\n\n\t\t\t       M E N U\n\n\n" ) ;
	printf ( "\t\t\t1.  Try it yourself\n\n" ) ;
	printf ( "\t\t\t2.  Let Computer solve it\n\n" ) ;
	printf ( "\t\t\t3.  Quit\n\n\n" ) ;
	printf ( "\n\n\nYour Choice : " ) ;
	return ;
}

int movdisc ( n1, n2 ) 
int n1, n2 ;
{
	int i, j, x, y, level, disc, gamend ;
	/* remove disc from stack n1 (movfrom) */
	level = top[n1][1] ;
	disc = top[n1][2] ;
	y = level + 3 ;
	x = posx[n1] - disc ;
	gotoxy ( x, y ) ;

	for ( i = 1 ; i <= disc * 2 ; i++ ) 
		printf ( "%c", DELCHAR ) ;
	stakpos[n1][level] = 0 ;

	if ( level == maxdisc ) 
	{
		top[n1][1] = 0 ;
		top[n1][2] = 0 ;
	}
	else
	{
		top[n1][1] = level + 1 ;
		top[n1][2] = stakpos[n1][level + 1] ;
	}

	/* place disc on stack n2 (movto) */

	if ( top[n2][1] == 0 ) 
		level = maxdisc ;
	else
		level = top[n2][1] - 1 ;
	y = level + 3 ;
	x = posx[n2] - disc ;
	gotoxy ( x, y ) ;

	for ( i = 1 ; i <= disc * 2 ; i++ ) 
		printf ( "%c", FILCHAR ) ;
	stakpos[n2][level] = disc ;
	top[n2][1] = level ;
	top[n2][2] = disc ;

	if ( demo == 1 ) 
	{
		gotoxy ( 1, 20 ) ;
		printf ( "Move Disc %d from Stack-%d to Stack-%d.", disc, n1, n2 ) ;

		if ( speed == 1 ) 
			for ( i = 0 ; i <= SLOW ; i++ ) 
				for ( j = 0 ; j <= SLOW ; j++ ) ;
				else
					if ( speed == 2 ) 
						for ( i = 0 ; i <= FAST ; i++ ) 
							for ( j = 0 ; j <= FAST ; j++ ) ;
							else
							{
								printf ( "\nPress any key to continue ...." ) ;
								getch() ;
								gotoxy ( 1, 20 ) ;
								printf ( "                                                             " ) ;
								printf ( "\n                                " ) ;
							}
					}

					if ( top[3][1] == 1 && top[3][2] == 1 ) 
						gamend = 1 ;
	else
		gamend = 0 ;
	return ( gamend ) ;
}

endplay()
{
	gotoxy ( 1, 20 ) ;

	if ( demo == 1 ) 
		printf ( "Solved!                                                      \n" ) ;
	else
	{
		printf ( "Task Completed.                                               \n" ) ;

		if ( moves == ( int ) pow ( 2, maxdisc ) - 1 ) 
			printf ( "Congratulations for completing in minimum possible moves !  \n" ) ;
	}

	printf ( "\nPress any key to go to Menu.                                  " ) ;
	getch() ;
	return ;
}

getmove()
{
	int stak, level, disc, again1 = 1, again2 = 1 ;
	moves++ ;
	gotoxy ( 1, 18 ) ;
	printf ( "Move No. : %d   ", moves ) ;

	while ( again1 == 1 ) 
	{

		while ( again2 == 1 ) 
		{
			gotoxy ( 1, 19 ) ;
			printf ( "Move top disc of Stack No.      " ) ;
			gotoxy ( 28, 19 ) ;
			scanf ( "%d", & stak ) ;

			if ( top[stak][1] == 0 ) 
			{
				gotoxy ( 35, 19 ) ;
				printf ( "Stack-%d is Empty !", stak ) ;
				getch() ;
				gotoxy ( 35, 19 ) ;
				printf ( "                            " ) ;
			}
			else
				again2 = 0 ;
		}

		;
		movfrom = stak ;
		disc = top[movfrom][2] ;
		gotoxy ( 1, 20 ) ;
		printf ( "       to top of Stack No.    " ) ;
		gotoxy ( 28, 20 ) ;
		scanf ( "%d", & stak ) ;

		if ( top[stak][1] != 0 && top[stak][2] < disc ) 
		{
			gotoxy ( 35, 20 ) ;
			printf ( "Illegal move !" ) ;
			getch() ;
			gotoxy ( 35, 20 ) ;
			printf ( "                          " ) ;
			again2 = 1 ;
		}
		else
			again1 = 0 ;
	}

	;
	movto = stak ;
	return ;
}

solve ( m, m1, m2, m3 ) 
int m, m1, m2, m3 ;
{
	int gend ;

	if ( m != 0 ) 
	{
		solve ( m - 1, m1, m3, m2 ) ;
		gend = movdisc ( m1, m3 ) ;
		solve ( m - 1, m2, m1, m3 ) ;
	}

	return ;
}

main()
{
	int gamover, choice = 1 ;
	initscr ( MAXDISC ) ;

	while ( choice < 3 ) 
	{
		initvars() ;
		menu() ;
		scanf ( "%d", & choice ) ;

		switch ( choice ) 
		{

			case 1 :

				printf ( "\n\nNo. of Discs to be used : " ) ;
				scanf ( "%d", & maxdisc ) ;

				if ( maxdisc < 1 ) 
					maxdisc = 1 ;

				if ( maxdisc > 10 ) 
					maxdisc = 10 ;
				initscr ( maxdisc ) ;

				while ( gamover != 1 ) 
				{
					getmove() ;
					gamover = movdisc ( movfrom, movto ) ;
				}

				;
				endplay() ;
				break ;

			case 2 :

				printf ( "\n\nNo. of Discs to be used : " ) ;
				scanf ( "%d", & maxdisc ) ;

				if ( maxdisc < 1 ) 
					maxdisc = 1 ;

				if ( maxdisc > 10 ) 
					maxdisc = 10 ;
				printf ( "\n\nSpeed (1=Slow, 2=Fast, 3=Step-by-step) : " ) ;
				scanf ( "%d", & speed ) ;
				initscr ( maxdisc ) ;
				solve ( maxdisc, 1, 2, 3 ) ;
				endplay() ;
				break ;

			case 3 :

				exit ( 0 ) ;
		}
	}

	;
}
