unit Protect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls,TlHelp32;

function IsDBG:Boolean;
function SoftIceVXDDetected: Boolean;
function BoundsCheckerDetected: Boolean;
function WinIceDetected: Boolean;
function MeltIceDetected: Boolean;
procedure FOLL();
function GetFSize(Handle: THandle): Int64;
procedure Checkit(ps:integer);
procedure KillMe();
procedure CallTest();


implementation

var
 Found:Boolean=False;
 hSnapmod: THANDLE;
 ModInfo: MODULEENTRY32;
 hSnap: THANDLE;
 ProcessInfo: PROCESSENTRY32;
 ProcID:DWORD;
 Tm1,Tm2:Int64;

function IsDebuggerPresent():BOOL; stdcall;external 'kernel32.dll' name 'IsDebuggerPresent';

function GetSys:string;
var
  Gsys : array[0..MAX_PATH] of Char;
begin
  GetSystemDirectory(Gsys,MAX_PATH);
  Result:=Gsys;
  if length(Result)>0 then
  if Result[length(Result)]<>'\' then Result:=Result+'\';
end;

function UpCaseStr(S:string):String;
var i:integer;
begin
  Result:=s;
  if s='' then exit;
  for i:=1 to length(s) do
    Result[i]:=upcase(Result[i]);
end;

function RDTSC: Int64; assembler;
asm
  DB 0fh ,031h
end;


function IsRing0DBG(S:string): boolean;
var hFile: Thandle;
begin
  Result := False;
  hFile := CreateFileA(PAnsichar(S),GENERIC_READ or GENERIC_WRITE,
    0, nil, OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL, 0);
  if( hFile <> INVALID_HANDLE_VALUE ) then begin
    CloseHandle(hFile);
    Result := TRUE;
  end;
end;


function IsDBG:Boolean;
var i: Integer;
begin
  Tm1:=RDTSC;
  for i:=0 to 255 do
    OutputDebugStringA('kernel32.dll');
  Tm2:=RDTSC-Tm1;
  if Tm2<9999 then Found:=True;
  if Tm2>299999999 then Found:=True;
  //hSnap:=CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS  ,0);
  ProcessInfo.dwSize:=sizeof(PROCESSENTRY32);
  Process32First(hSnap,ProcessInfo);
  repeat
   if Pos('OLLYDBG',UpCaseStr(ProcessInfo.szExeFile))<>0 then Found:=True;
   if Pos('DBG',UpCaseStr(ProcessInfo.szExeFile))<>0 then Found:=True;
   if Pos('DEBUG',UpCaseStr(ProcessInfo.szExeFile))<>0 then Found:=True;
   if Pos('IDAG',UpCaseStr(ProcessInfo.szExeFile))<>0 then Found:=True;
   if Pos('W32DSM',UpCaseStr(ProcessInfo.szExeFile))<>0 then Found:=True;
   ProcID:=ProcessInfo.th32ProcessID;
   hSnapMod:=CreateToolhelp32Snapshot(TH32CS_SNAPMODULE,ProcID);
   ModInfo.dwSize:=sizeof(MODULEENTRY32);
   Module32First(hSnapMod,ModInfo);
   repeat
    if Pos('DBGHELP',UpCaseStr(ModInfo.szExePath))<>0 then Found:=True;
    if Pos('OLLYDBG',UpCaseStr(ModInfo.szExePath))<>0 then Found:=True;
    if Pos('W32DSM',UpCaseStr(ModInfo.szExePath))<>0 then Found:=True;
   until (not Module32Next(hSnapMod,ModInfo));
   CloseHandle(hSnapMod);
  until (not Process32Next(hSnap,ProcessInfo));
  CloseHandle(hSnap);

  if FileExists(GetSys+'drivers\sice.sys') then Found:=True;
  if FileExists(GetSys+'drivers\ntice.sys') then Found:=True;
  if FileExists(GetSys+'drivers\syser.sys') then Found:=True;
  if FileExists(GetSys+'drivers\winice.sys') then Found:=True;
  if FileExists(GetSys+'drivers\sice.vxd') then Found:=True;
  if FileExists(GetSys+'drivers\winice.vxd') then Found:=True;
  if FileExists(GetSys+'winice.vxd') then Found:=True;
  if FileExists(GetSys+'vmm32\winice.vxd') then Found:=True;
  if FileExists(GetSys+'sice.vxd') then Found:=True;
  if FileExists(GetSys+'vmm32\sice.vxd') then Found:=True;
  if IsDebuggerPresent then Found:=True;
  if IsRing0DBG('\\.\SICE') then Found:=True;
  if IsRing0DBG('\\.\SIWVID') then Found:=True;
  if IsRing0DBG('\\.\NTICE') then Found:=True;
  if IsRing0DBG('\\.\TRW') then Found:=True;
  if IsRing0DBG('\\.\TWX') then Found:=True;
  if IsRing0DBG('\\.\ICEEXT') then Found:=True;
  Result:=Found;
end;

function BoundsCheckerDetected: Boolean;
begin
  try
    asm
      push  ebp
      mov   ebp, 'BCHK'
      mov   ax, 4
      int   3
      cmp   ax, 4
      jne   @@softice_detected
      mov   ax, 0
      jmp   @@exit
      @@softice_detected:
      mov   ax, 1
      @@exit:
      pop   ebp
    end;
   except
   on E: EExternalException do
    begin
        result:=False;
    end else begin
    result:=true;
    end;
   end;
end;


function SoftIceVXDDetected: Boolean;
begin
  try
     asm
        push  esi
        push  edi
        mov   ax, $1684
        mov   bx, $0202 // VXD ID for SoftIce
        xor   di, di
        mov   es, di
        int   $2F
        mov   ax, es
        add   di,ax
        cmp   di, 0
        jne   @@softice_detected
        mov   ax, 0
        jmp   @@exit
     @@softice_detected:
        mov   ax, 1
     @@exit:
        pop   edi
        pop   esi
     end;
  except
     // Not hooked
     result:=False;
  end;
end;


function WinIceDetected: Boolean;
begin
  try
     asm
        mov   ah, $43
        int   $68
        cmp   ax, $F386
        jz    @@winice_detected
        mov   ax, 0
        jmp   @@exit
     @@winice_detected:
        mov   ax, 1
     @@exit:
     end;
  except
     // Not hooked
     result:=False;
  end;
end;


function MeltIceDetected: Boolean;
var  hIce:       THandle;
     dwCount:    Integer;
const
  ICE_FILES:     Array [0..3] of PChar = ('\\.\SICE', '\\.\NTICE', '\\.\SIWVID', '\\.\FROGICE');
begin

  // Description: Detect the presence of SoftIce and many other memory resident
  // tools by attempting to load SoftIce related devices such its display
  // driver, or its access driver. Devices such as SICE, NTICE, SIWVID, FROGICE.
  result:=False;
  for dwCount:=0 to High(ICE_FILES) do
  begin
     hIce:=CreateFile(ICE_FILES[dwCount], GENERIC_READ, 0, nil, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, 0);
     if (hIce <> INVALID_HANDLE_VALUE) then
     begin
        CloseHandle(hIce);
        result:=True;
        break;
     end;
  end;
end;




procedure FOLL();
begin
asm
        mov eax, fs:[$30]
        mov eax, [eax+$C]
        mov eax, [eax+$C]
        add dword ptr [eax+$20], $2000
end;
end;




function GetFSize(Handle: THandle): Int64;
  var
    i64: record
      LoDWord: LongWord;
      HiDWord: LongWord;
    end;
  begin
    i64.LoDWord := GetFileSize(Handle, @i64.HiDWord);
    if (i64.LoDWord = MAXDWORD) and (GetLastError <> 0) then
      Result := 0
    else
      Result := PInt64(@i64)^;
  end;

procedure Checkit(ps:integer);
var
  Stream:TFileStream;
  FSize2:int64;
begin
Stream := nil;
    try
      Stream := TFileStream.Create(Application.ExeName,fmOpenRead or fmShareDenyNone);
      Fsize2:=GetFSize(Stream.Handle);
       if FSize2 <> ps then killme;
       if FSize2 > ps then killme;
    finally
      Stream.Free;
    end;
end;




procedure KillMe();
begin
  halt;
  Application.Terminate();
end;
procedure Test();
var
  Msg : String;
begin
  msg := 'Hiiii :D';
  ShowMessage(Msg);
  asm
    mov eax, [ebp + 4]
    mov ebx, [eax]
    and ebx, $FF
    sub ebx, $CC
    jne @def
    add eax,5
    mov [ebp + 4], eax
@def:
  end;
end;


procedure CallTest();
begin

    Test();
  asm
    jmp @def
    nop
    nop
    nop
    nop
    call KillMe
@def:
  end;

end;

end.
